ORCA/M Asm65816 2.1.0

0001 EF2B                       EJECT 
0002 EF2B              *******************************************************************************
0003 EF2B              *
0004 EF2B              GetKeyTranslation   PROC EXPORT  
0005 EF2B              *
0006 EF2B              * Description:      returns the current keyboard translation number
0007 EF2B              *
0008 EF2B              *
0009 EF2B              * Inputs:   None
0010 EF2B              *
0011 EF2B              * Outputs:          TransID:WORD
0012 EF2B              *
0013 EF2B              * External Refs:
0014 EF2B              *
0015 EF2B              * Entry Points:
0016 EF2B              *
0017 EF2B              *******************************************************************************
0018 EF2B              SaveDPage equ 1 
0019 EF2B              RTL1     equ SaveDPage+2 
0020 EF2B              RTL2     equ RTL1+3 
0021 EF2B              Result   equ RTL2+3 
0022 EF2B
0023 EF2B              ; first set up the stack the way we want to see it!
0024 EF2B 0B                    phd                            ; save the old direct register
0025 EF2C 5B                    tcd                            ; and use the EMDirectPage
0026 EF2D D0 05                 bne   @OK1                     ; If em's dpage is zero then tool not started
0027 EF2F A2 03 06              ldx   #ActiveErr               ; return error if em not started
0028 EF32 80 15                 bra   @ErrOut
0029 EF34              ;
0030 EF34              ; If we get here, everything is groovy!
0031 EF34              @OK1      
0032 EF34              ; get the current translation from BRAM ...
0033 EF34
0034 EF34 48                    pha                            ; room for result
0035 EF35 A9 5A 00              lda   #kTransBParamLoc
0036 EF38 48                    pha   
0037 EF39 A2 03 0C 22           _ReadBParam                    ; get our parameter
0038 EF40 B0 03                 bcs   @1                       ; if error skip next line
0039 EF42 A9 00 00              lda   #0                       ; no error, use zero here
0040 EF45 AA           @1       tax                            ; store the error in <X>
0041 EF46
0042 EF46 68                    pla   
0043 EF47 83 09                 sta   Result,s                 ; save it as our result
0044 EF49              @ErrOut   
0045 EF49 2B                    pld                            ; restore the direct page
0046 EF4A 8A                    txa                            ; put the error in <A>
0047 EF4B C9 01 00              cmp   #1                       ; and set the carry if error <>0
0048 EF4E 6B                    rtl                            ; and exit.
0049 EF4F
0050 EF4F                       EndP 
0051 EF4F
0052 EF4F                       EJECT 
0053 EF4F              *******************************************************************************
0054 EF4F              *
0055 EF4F              SetKeyTranslation PROC EXPORT
0056 EF4F              *
0057 EF4F              * Description:      Dumps the old key translation table that we were using, and
0058 EF4F              *                   if the number passed is valid, sets a new one. If the passed
0059 EF4F              *                   number is invalid, then we set it to $FF, or standard.
0060 EF4F              *
0061 EF4F              *
0062 EF4F              * Inputs:           TransID:WORD
0063 EF4F              *
0064 EF4F              * Outputs:          None
0065 EF4F              *
0066 EF4F              * External Refs:
0067 EF4F              *
0068 EF4F              * Entry Points:
0069 EF4F              *
0070 EF4F              *******************************************************************************
0071 EF4F              SaveDPage equ 1 
0072 EF4F              RTL1     equ SaveDPage+2 
0073 EF4F              RTL2     equ RTL1+3 
0074 EF4F              TransID  equ RTL2+3 
0075 EF4F              ; first set up the stack the way we want to see it!
0076 EF4F 0B                    phd                            ; save the old direct register
0077 EF50 5B                    tcd                            ; and use the EMDirectPage
0078 EF51 D0 06                 bne   @OK1                     ; If em's dpage is zero then tool not started
0079 EF53 A2 03 06              ldx   #ActiveErr               ; return error if em not started
0080 EF56 82 BF 00              brl   @ErrOut
0081 EF59              ;
0082 EF59              ; If we get here, everything is groovy!
0083 EF59              @OK1      
0084 EF59              ; First thing to do is swap in the Apps resID if the event manager exists...
0085 EF59 64 6C                 stz   <kTransTemp
0086 EF5B
0087 EF5B F4 00 00              pea   0
0088 EF5E A2 1E 06 22           _ResourceStatus 
0089 EF65 68                    pla   
0090 EF66 F0 14                 beq   @NoResMgr                ; if zero, no resource manager...
0091 EF68 48                    pha   
0092 EF69 A2 1E 14 22           _GetCurResourceApp 
0093 EF70 68                    pla   
0094 EF71 85 6C                 sta   <kTransTemp
0095 EF73
0096 EF73 D4 60                 pei   <ProgID                  ; swap the apps res file in...
0097 EF75 A2 1E 13 22           _SetCurResourceApp 
0098 EF7C              @NoResMgr  
0099 EF7C              ; get the current translation from BRAM ...
0100 EF7C
0101 EF7C A5 66                 lda   <kTransRef               ; test to see if we have a table in current use...
0102 EF7E 05 68                 ora   <kTransRef+2
0103 EF80 D0 03                 bne   @OK2
0104 EF82 82 30 00              brl   @LoadNew                 ; if not, just load us a new one!
0105 EF85              @OK2      
0106 EF85 48                    pha                            ; room for result
0107 EF86 A9 5A 00              lda   #kTransBParamLoc
0108 EF89 48                    pha   
0109 EF8A A2 03 0C 22           _ReadBParam                    ; get our parameter
0110 EF91 90 05                 bcc   @1                       ; if error skip next line
0111 EF93 AA                    tax                            ; place the error in <X>
0112 EF94 68                    pla                            ; strip the offending junk from the stack
0113 EF95 82 80 00              brl   @ErrOut                  ; and report the error
0114 EF98
0115 EF98              @1        
0116 EF98 68                    pla                            ; convert it to the right number
0117 EF99 29 FF 00              and   #$00FF
0118 EF9C 09 00 06              ora   #$0600                   ; add event mgr ID
0119 EF9F AA                    tax                            ; save it in <X> for a second...
0120 EFA0
0121 EFA0 F4 21 80              pea   $8021                    ; ktrans resource type
0122 EFA3 F4 FF 0F              pea   $0FFF                    ; resource ID
0123 EFA6              ; create the low byte of the ID here!
0124 EFA6 DA                    phx                            ; event manager resource #1
0125 EFA7 A2 03 36 22           _ReleaseRomResource            ; now call releaseROMResource
0126 EFAE 90 05                 bcc   @2                       ; 
0127 EFB0 AA                    tax                            ; place the error in <X>
0128 EFB1 68                    pla                            ; strip the offending junk from the stack
0129 EFB2 82 63 00              brl   @ErrOut                  ; and report the error
0130 EFB5
0131 EFB5              @2        
0132 EFB5              ;
0133 EFB5              ; This next routine tries to load the passed ktrans table, if its -1, it will try to
0134 EFB5              ; load the default.
0135 EFB5              @LoadNew  
0136 EFB5 64 66                 stz   <ktransRef
0137 EFB7 64 68                 stz   <ktransRef+2
0138 EFB9 64 6A                 stz   <kTransFlag
0139 EFBB
0140 EFBB A3 09                 lda   TransID,s                ; load in the translation ID
0141 EFBD 10 0E                 bpl   @LN0010
0142 EFBF
0143 EFBF 48                    pha                            ; room for result
0144 EFC0 F4 5A 00              pea   kTransBParamLoc
0145 EFC3 A2 03 0C 22           _ReadBParam                    ; get our parameter
0146 EFCA 68                    pla   
0147 EFCB 83 09                 sta   TransID,s                ; and save this as the proper translation to load
0148 EFCD
0149 EFCD A3 09        @LN0010  lda   TransID,s                ; get the desired translation...
0150 EFCF F0 36                 beq   @DLKTDone                ; if zero, then bag it!
0151 EFD1 29 FF 00              and   #$00FF
0152 EFD4 09 00 06              ora   #$0600                   ; add event mgr ID
0153 EFD7 AA                    tax                            ; save it in <X> for a seconf...
0154 EFD8 48                    pha                            ; room for result
0155 EFD9 48                    pha   
0156 EFDA F4 21 80              pea   $8021                    ; ktrans resource type
0157 EFDD F4 FF 0F              pea   $0FFF                    ; resource ID
0158 EFE0              ; create the low byte of the ID here!
0159 EFE0 DA                    phx                            ; event manager resource #
0160 EFE1 A2 03 35 22           _GetRomResource                ; now call getROMResource
0161 EFE8 90 17                 bcc   @LN0020                  ; If any error occured, try the default translation...
0162 EFEA 68                    pla   
0163 EFEB 68                    pla   
0164 EFEC A3 09                 lda   transID,s                ; get the current trans ID...
0165 EFEE C9 FF 00              cmp   #$00FF                   ; is it the default?
0166 EFF1 F0 07                 beq   @LN0015                  ; if so, skip the next line...
0167 EFF3 A9 FF 00              lda   #$00FF                   ; if an error occured, use ROM based res
0168 EFF6 83 09                 sta   TransID,s
0169 EFF8 80 D3                 bra   @LN0010                  ; and try again!
0170 EFFA
0171 EFFA              ; This next two lines should never be executed, but just in case....
0172 EFFA A9 00 00     @LN0015  lda   #00                      ; set the translation to none
0173 EFFD 83 09                 sta   TransID,s
0174 EFFF 80 06                 bra   @DLKTDone
0175 F001
0176 F001 68           @LN0020  pla   
0177 F002 85 66                 sta   <ktransRef               ; save the resource handle
0178 F004 68                    pla   
0179 F005 85 68                 sta   <ktransRef+2             ; save the pointer+2
0180 F007              @DLKTDone  
0181 F007 A3 09                 lda   TransID,s                ; now set batteryRAM to the new value
0182 F009 48                    pha   
0183 F00A A9 5A 00              lda   #kTransBParamLoc
0184 F00D 48                    pha   
0185 F00E A2 03 0B 22           _WriteBParam                   ; and write the battery parameter.
0186 F015 A9 00 00              lda   #0                       ; set no error
0187 F018
0188 F018              @ErrOut   
0189 F018 DA                    phx   
0190 F019
0191 F019 F4 00 00              pea   0
0192 F01C A2 1E 06 22           _ResourceStatus 
0193 F023 68                    pla   
0194 F024 F0 09                 beq   @NoResMgr2               ; if zero, no resource manager...
0195 F026
0196 F026 D4 6C                 pei   <kTransTemp              ; swap the apps res file in...
0197 F028 A2 1E 13 22           _SetCurResourceApp 
0198 F02F              @NoResMgr2  
0199 F02F FA                    plx   
0200 F030 A3 07                 lda   RTL1+4,s                 ; move the return address
0201 F032 83 09                 sta   RTL1+6,s
0202 F034 A3 05                 lda   RTL1+2,s                 ; move the return address
0203 F036 83 07                 sta   RTL1+4,s
0204 F038 A3 03                 lda   RTL1,s                   ; move the return address
0205 F03A 83 05                 sta   RTL1+2,s
0206 F03C 2B                    pld                            ; restore the direct page
0207 F03D 68                    pla                            ; discard parameter overhead
0208 F03E 8A                    txa                            ; put the error in <A>
0209 F03F C9 01 00              cmp   #1                       ; and set the carry if error <>0
0210 F042 6B                    rtl                            ; and exit.
0211 F043
0212 F043                       EndP 
